/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.SpriteAwareVertexBuilder;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MipmapGenerator;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.resources.data.AnimationFrame;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.ResourceLocation;

public class TextureAtlasSprite
implements AutoCloseable {
    private final AtlasTexture field_229225_b_;
    private final Info field_229226_c_;
    private final AnimationMetadataSection field_110982_k;
    protected final NativeImage[] field_195670_c;
    private final int[] field_195671_d;
    private final int[] field_195672_e;
    @Nullable
    private final InterpolationData field_229227_g_;
    private final int field_110975_c;
    private final int field_110974_d;
    private final float field_110979_l;
    private final float field_110980_m;
    private final float field_110977_n;
    private final float field_110978_o;
    private int field_110973_g;
    private int field_110983_h;

    protected TextureAtlasSprite(AtlasTexture atlasTexture, Info info, int n, int n2, int n3, int n4, int n5, NativeImage nativeImage) {
        CrashReport crashReport;
        this.field_229225_b_ = atlasTexture;
        AnimationMetadataSection \u26037 = info.field_229247_d_;
        int \u26032 = info.field_229245_b_;
        int \u26033 = info.field_229246_c_;
        this.field_110975_c = n4;
        this.field_110974_d = n5;
        this.field_110979_l = (float)n4 / (float)n2;
        this.field_110980_m = (float)(n4 + \u26032) / (float)n2;
        this.field_110977_n = (float)n5 / (float)n3;
        this.field_110978_o = (float)(n5 + \u26033) / (float)n3;
        int \u26034 = nativeImage.func_195702_a() / \u26037.func_229302_b_(\u26032);
        int \u26035 = nativeImage.func_195714_b() / \u26037.func_229301_a_(\u26033);
        if (\u26037.func_110473_c() > 0) {
            int n6 = (Integer)\u26037.func_130073_e().stream().max(Integer::compareTo).get() + 1;
            this.field_195671_d = new int[n6];
            this.field_195672_e = new int[n6];
            Arrays.fill(this.field_195671_d, -1);
            Arrays.fill(this.field_195672_e, -1);
            for (int n7 : \u26037.func_130073_e()) {
                if (n7 >= \u26034 * \u26035) {
                    throw new RuntimeException("invalid frameindex " + n7);
                }
                \u2603 = n7 / \u26034;
                this.field_195671_d[n7] = \u2603 = n7 % \u26034;
                this.field_195672_e[n7] = \u2603;
            }
        } else {
            ArrayList arrayList = Lists.newArrayList();
            int \u26036 = \u26034 * \u26035;
            this.field_195671_d = new int[\u26036];
            this.field_195672_e = new int[\u26036];
            for (int n7 = 0; n7 < \u26035; ++n7) {
                \u2603 = 0;
                while (\u2603 < \u26034) {
                    \u2603 = n7 * \u26034 + \u2603;
                    this.field_195671_d[\u2603] = \u2603++;
                    this.field_195672_e[\u2603] = n7;
                    arrayList.add(new AnimationFrame(\u2603, -1));
                }
            }
            \u26037 = new AnimationMetadataSection(arrayList, \u26032, \u26033, \u26037.func_110469_d(), \u26037.func_177219_e());
        }
        this.field_229226_c_ = new Info(info.field_229244_a_, \u26032, \u26033, \u26037);
        this.field_110982_k = \u26037;
        try {
            try {
                this.field_195670_c = MipmapGenerator.func_229173_a_(nativeImage, n);
            }
            catch (Throwable \u26038) {
                crashReport = CrashReport.func_85055_a(\u26038, "Generating mipmaps for frame");
                CrashReportCategory \u26039 = crashReport.func_85058_a("Frame being iterated");
                \u26039.func_189529_a("First frame", () -> {
                    StringBuilder stringBuilder = new StringBuilder();
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(nativeImage.func_195702_a()).append("x").append(nativeImage.func_195714_b());
                    return stringBuilder.toString();
                });
                throw new ReportedException(crashReport);
            }
        }
        catch (Throwable throwable) {
            crashReport = CrashReport.func_85055_a(throwable, "Applying mipmap");
            CrashReportCategory \u260310 = crashReport.func_85058_a("Sprite being mipmapped");
            \u260310.func_189529_a("Sprite name", () -> this.func_195668_m().toString());
            \u260310.func_189529_a("Sprite size", () -> this.func_94211_a() + " x " + this.func_94216_b());
            \u260310.func_189529_a("Sprite frames", () -> this.func_110970_k() + " frames");
            \u260310.func_71507_a("Mipmap levels", n);
            throw new ReportedException(crashReport);
        }
        this.field_229227_g_ = \u26037.func_177219_e() ? new InterpolationData(info, n) : null;
    }

    private void func_195659_d(int n) {
        \u2603 = this.field_195671_d[n] * this.field_229226_c_.field_229245_b_;
        \u2603 = this.field_195672_e[n] * this.field_229226_c_.field_229246_c_;
        this.func_195667_a(\u2603, \u2603, this.field_195670_c);
    }

    private void func_195667_a(int n, int n2, NativeImage[] nativeImageArray) {
        for (int i = 0; i < this.field_195670_c.length; ++i) {
            nativeImageArray[i].func_227788_a_(i, this.field_110975_c >> i, this.field_110974_d >> i, n >> i, n2 >> i, this.field_229226_c_.field_229245_b_ >> i, this.field_229226_c_.field_229246_c_ >> i, this.field_195670_c.length > 1, false);
        }
    }

    public int func_94211_a() {
        return this.field_229226_c_.field_229245_b_;
    }

    public int func_94216_b() {
        return this.field_229226_c_.field_229246_c_;
    }

    public float func_94209_e() {
        return this.field_110979_l;
    }

    public float func_94212_f() {
        return this.field_110980_m;
    }

    public float func_94214_a(double d) {
        float f = this.field_110980_m - this.field_110979_l;
        return this.field_110979_l + f * (float)d / 16.0f;
    }

    public float func_94206_g() {
        return this.field_110977_n;
    }

    public float func_94210_h() {
        return this.field_110978_o;
    }

    public float func_94207_b(double d) {
        float f = this.field_110978_o - this.field_110977_n;
        return this.field_110977_n + f * (float)d / 16.0f;
    }

    public ResourceLocation func_195668_m() {
        return this.field_229226_c_.field_229244_a_;
    }

    public AtlasTexture func_229241_m_() {
        return this.field_229225_b_;
    }

    public int func_110970_k() {
        return this.field_195671_d.length;
    }

    @Override
    public void close() {
        for (NativeImage nativeImage : this.field_195670_c) {
            if (nativeImage == null) continue;
            nativeImage.close();
        }
        if (this.field_229227_g_ != null) {
            this.field_229227_g_.close();
        }
    }

    public String toString() {
        int n = this.field_195671_d.length;
        return "TextureAtlasSprite{name='" + this.field_229226_c_.field_229244_a_ + '\'' + ", frameCount=" + n + ", x=" + this.field_110975_c + ", y=" + this.field_110974_d + ", height=" + this.field_229226_c_.field_229246_c_ + ", width=" + this.field_229226_c_.field_229245_b_ + ", u0=" + this.field_110979_l + ", u1=" + this.field_110980_m + ", v0=" + this.field_110977_n + ", v1=" + this.field_110978_o + '}';
    }

    public boolean func_195662_a(int n, int n2, int n3) {
        return (this.field_195670_c[0].func_195709_a(n2 + this.field_195671_d[n] * this.field_229226_c_.field_229245_b_, n3 + this.field_195672_e[n] * this.field_229226_c_.field_229246_c_) >> 24 & 0xFF) == 0;
    }

    public void func_195663_q() {
        this.func_195659_d(0);
    }

    private float func_229228_a_() {
        float f = (float)this.field_229226_c_.field_229245_b_ / (this.field_110980_m - this.field_110979_l);
        \u2603 = (float)this.field_229226_c_.field_229246_c_ / (this.field_110978_o - this.field_110977_n);
        return Math.max(\u2603, f);
    }

    public float func_229242_p_() {
        return 4.0f / this.func_229228_a_();
    }

    public void func_94219_l() {
        ++this.field_110983_h;
        if (this.field_110983_h >= this.field_110982_k.func_110472_a(this.field_110973_g)) {
            int n = this.field_110982_k.func_110468_c(this.field_110973_g);
            \u2603 = this.field_110982_k.func_110473_c() == 0 ? this.func_110970_k() : this.field_110982_k.func_110473_c();
            this.field_110973_g = (this.field_110973_g + 1) % \u2603;
            this.field_110983_h = 0;
            \u2603 = this.field_110982_k.func_110468_c(this.field_110973_g);
            if (n != \u2603 && \u2603 >= 0 && \u2603 < this.func_110970_k()) {
                this.func_195659_d(\u2603);
            }
        } else if (this.field_229227_g_ != null) {
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.field_229227_g_.func_229257_a_());
            } else {
                this.field_229227_g_.func_229257_a_();
            }
        }
    }

    public boolean func_130098_m() {
        return this.field_110982_k.func_110473_c() > 1;
    }

    public IVertexBuilder func_229230_a_(IVertexBuilder iVertexBuilder) {
        return new SpriteAwareVertexBuilder(iVertexBuilder, this);
    }

    final class InterpolationData
    implements AutoCloseable {
        private final NativeImage[] field_229256_b_;

        private InterpolationData(Info info, int n) {
            this.field_229256_b_ = new NativeImage[n + 1];
            for (\u2603 = 0; \u2603 < this.field_229256_b_.length; ++\u2603) {
                \u2603 = info.field_229245_b_ >> \u2603;
                \u2603 = info.field_229246_c_ >> \u2603;
                if (this.field_229256_b_[\u2603] != null) continue;
                this.field_229256_b_[\u2603] = new NativeImage(\u2603, \u2603, false);
            }
        }

        private void func_229257_a_() {
            double d = 1.0 - (double)TextureAtlasSprite.this.field_110983_h / (double)TextureAtlasSprite.this.field_110982_k.func_110472_a(TextureAtlasSprite.this.field_110973_g);
            int \u26032 = TextureAtlasSprite.this.field_110982_k.func_110468_c(TextureAtlasSprite.this.field_110973_g);
            int \u26033 = TextureAtlasSprite.this.field_110982_k.func_110473_c() == 0 ? TextureAtlasSprite.this.func_110970_k() : TextureAtlasSprite.this.field_110982_k.func_110473_c();
            int \u26034 = TextureAtlasSprite.this.field_110982_k.func_110468_c((TextureAtlasSprite.this.field_110973_g + 1) % \u26033);
            if (\u26032 != \u26034 && \u26034 >= 0 && \u26034 < TextureAtlasSprite.this.func_110970_k()) {
                for (int i = 0; i < this.field_229256_b_.length; ++i) {
                    \u2603 = TextureAtlasSprite.this.field_229226_c_.field_229245_b_ >> i;
                    \u2603 = TextureAtlasSprite.this.field_229226_c_.field_229246_c_ >> i;
                    for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                        for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                            \u2603 = this.func_229259_a_(\u26032, i, \u2603, \u2603);
                            \u2603 = this.func_229259_a_(\u26034, i, \u2603, \u2603);
                            \u2603 = this.func_229258_a_(d, \u2603 >> 16 & 0xFF, \u2603 >> 16 & 0xFF);
                            \u2603 = this.func_229258_a_(d, \u2603 >> 8 & 0xFF, \u2603 >> 8 & 0xFF);
                            \u2603 = this.func_229258_a_(d, \u2603 & 0xFF, \u2603 & 0xFF);
                            this.field_229256_b_[i].func_195700_a(\u2603, \u2603, \u2603 & 0xFF000000 | \u2603 << 16 | \u2603 << 8 | \u2603);
                        }
                    }
                }
                TextureAtlasSprite.this.func_195667_a(0, 0, this.field_229256_b_);
            }
        }

        private int func_229259_a_(int n, int n2, int n3, int n4) {
            return TextureAtlasSprite.this.field_195670_c[n2].func_195709_a(n3 + (TextureAtlasSprite.this.field_195671_d[n] * TextureAtlasSprite.this.field_229226_c_.field_229245_b_ >> n2), n4 + (TextureAtlasSprite.this.field_195672_e[n] * TextureAtlasSprite.this.field_229226_c_.field_229246_c_ >> n2));
        }

        private int func_229258_a_(double d, int n, int n2) {
            return (int)(d * (double)n + (1.0 - d) * (double)n2);
        }

        @Override
        public void close() {
            for (NativeImage nativeImage : this.field_229256_b_) {
                if (nativeImage == null) continue;
                nativeImage.close();
            }
        }
    }

    public static final class Info {
        private final ResourceLocation field_229244_a_;
        private final int field_229245_b_;
        private final int field_229246_c_;
        private final AnimationMetadataSection field_229247_d_;

        public Info(ResourceLocation resourceLocation, int n, int n2, AnimationMetadataSection animationMetadataSection) {
            this.field_229244_a_ = resourceLocation;
            this.field_229245_b_ = n;
            this.field_229246_c_ = n2;
            this.field_229247_d_ = animationMetadataSection;
        }

        public ResourceLocation func_229248_a_() {
            return this.field_229244_a_;
        }

        public int func_229250_b_() {
            return this.field_229245_b_;
        }

        public int func_229252_c_() {
            return this.field_229246_c_;
        }
    }
}

